Attribute VB_Name = "MNT_FNC"
'########################################################################################################
'###################################### S1X-MONITOR-HAUPT-MODUL #########################################
'########################################################################################################




Global DIRhom_mnt As String '........................................................... StammVerzeichnis
Global LCDlng_mnt As String '.......................................................... SprachEinstellung
Global TXTmsg_stp As String '......................................................... FehlerAusschriften
Global NBRccl_dat As Integer '............................................ Anzahl Zyklen mit DatenAusgabe

'............................................................................. StandartWinkel in BogenMa
Global Pi090 As Double: Global Pi180 As Double
Global Pi270 As Double: Global Pi360 As Double


'---------------------------------------------- DATENBANK  ----------------------------------------------
Global PTHdbs_mnt As String '.................................................. Verzeichnis der Datenbank
Global DBScnn_mnt As Integer '...... DatenbankVerfgbarkeit (0=nicht verfgbar, 1=leer, 2=Daten abrufbar)
Global DBSobj_mnt As Database '.......................................................... DatenbankObjekt
Global CRSobj_mnt As Recordset '......................................................... DatenbankCursor
Global CRSobj_tmp As Recordset '......................................................... DatenbankCursor



'---------------------------------------------- MESS-STATIONEN  -----------------------------------------
Global NBRmsr_stc As Integer '................................................... Anzahl der MeStationen
Global RCTstc_hrz(99) As Integer '........................................ Werte rechter HorizontalWinkel
Global PRCstc_hrz(99) As Single '................................... Genauigkeit der horizontalen Messung
Global RCTstc_vtc(99) As Integer '.......................................... Werte rechter VertikalWinkel
Global PRCstc_vtc(99) As Single '..................................... Genauigkeit der vertikalen Messung

Global ALPstc_lnc(99) As Single '.................. Winkel zwischen StartStelle und vorheriger MeStation
Global BTAstc_lnc(99) As Single '.................... Winkel zwischen StartStelle und nchster MeStation
Global GMAstc_lnc(99) As Single '..................... VertikalWinkel zwischen MeStation und StartStelle
Global DSTstc_lnc(99) As Long '.................. Gemessene Abstnde der MeStationen zur StartStelle [m]

Global ALPstl_bgm(99) As Double '............................. Werte ALPstc_lnc() umgerechnet in Bogenma
Global BTAstl_bgm(99) As Double '............................. Werte BTAstc_lnc() umgerechnet in Bogenma
Global GMAstl_bgm(99) As Double '............................. Werte GMAstc_lnc() umgerechnet in Bogenma

Global XXXstc_loc(99) As Double, YYYstc_loc(99) As Double, ZZZstc_loc(99) As Double '.... RaumKoordinaten
Global DSTstc_lnc_pxz(99) As Integer '....... Projektion von DSTstc_lnc() auf die Ebene des StartGelndes
Global DSTstc_stc(99, 2) As Long '........................... Abstnde zwischen benachbarten MeStationen
Global OMGstl_bgm(99) As Double '.............. Winkel zwischen AbstandsLinie zur StartStelle und Z-Achse



'-------------------------------------------- ERGEBNIS-LISTE --------------------------------------------
Global IDXcnt_mnt As Integer '........................................... Index des aktuellen Wettbewerbs
Global CPTcnt_mnt As String '........................................ Bezeichner des aktuellen Wettbewrbs

Global WDTcmp_max As Integer
Global CMPwdt_max As String

Global TABmnt_lst(99) As Long
Global HGHrow_lst As Integer
Global NBRrow_mnt As Long
Global NRCdat_mnt As Long
Global RECdat_mnt() As String
    
Global NRCscr_mnt As Long '.................................. Anzahl gescrollter Zeilen der ErgebnisListe

Dim RECdat_tmp$()
Dim HGHfly$(), ERRfly$(), STSfly$()

'..................................................................................... Aktueller BestWert
Global IDXcmp_win As String
Global NAMcmp_win As String
Global IDXfly_win As String
 
'========================================================================================================
'======================= FORMATIEREN EINES RECORDS DER ERGEBNIS-LISTE EINES WETTBEWRBS ==================
'
  Function MntCtrFmtRecord$(IDXcnt%)
'                                                         SELECT cmp_index, name, name_add, result, place
'........................................................................................................




'.................................................................................... Index (StartNummer)
CLMx% = CLMx% + 1
NBRx$ = LTrim(Str(CRSobj_mnt(0)))
RECx$ = MntCtrFmtNumber$(NBRx$, "NBR_3_0") + Chr(CLMx%)

'................................................................................................... Name
CLMx% = CLMx% + 1
If Not IsNull(CRSobj_mnt(1)) Then NAMx$ = CRSobj_mnt(1)
RECx$ = RECx$ + NAMx$ + Chr(CLMx%)

'....................................................................................... Lizenz/Club/Land
CLMx% = CLMx% + 1
If Not IsNull(CRSobj_mnt(2)) Then LCLx$ = CRSobj_mnt(2)
RECx$ = RECx$ + LCLx$ + Chr(CLMx%)

CMPx$ = NAMx$ + "           " + LCLx$
WDTx% = MNT_CTR.RecLstPct.TextWidth(CMPx$)
If WDTx% > WDTcmp_max Then WDTcmp_max = WDTx%: CMPwdt_max = CMPx$

'................................................................................................. Result
If Not IsNull(CRSobj_mnt(3)) Then ALTcnt_cmp& = CRSobj_mnt(3) Else ALTcnt_cmp& = 0
  
'.................................................................................................. Place
If Not IsNull(CRSobj_mnt(4)) Then POScnt_cmp& = CRSobj_mnt(4)

'................................................................................... Ergebnisse der Flge
ReDim HGHfly$(3), ERRfly$(3), STSfly$(3)


        QRYx$ = " SELECT "
QRYx$ = QRYx$ + " fly_index, hgh, err, sts"
QRYx$ = QRYx$ + " FROM s1x_fly"
QRYx$ = QRYx$ + " WHERE cnt_index =" + Str(IDXcnt%) + " AND cmp_index = " + NBRx$
QRYx$ = QRYx$ + " ORDER BY fly_index"

Set CRSobj_tmp = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)

  Do While Not CRSobj_tmp.EOF
    IDXfly% = CRSobj_tmp(0)
      
      Select Case CRSobj_tmp(3)
        Case "DQ"
          HGHfly$(IDXfly%) = ""
          ERRfly$(IDXfly%) = ""
        
        Case "TL"
          HGHfly$(IDXfly%) = "- - "
          ERRfly$(IDXfly%) = "- - "
        
        Case Else
        
            If CRSobj_tmp(1) > 0 Then
              HGHfly$(IDXfly%) = LTrim(Str(CRSobj_tmp(1)))
              ERRfly$(IDXfly%) = LTrim(Str(CRSobj_tmp(2)))
            Else '............................................................. NC fr alle StationsPaare
              HGHfly$(IDXfly%) = "- - "
              ERRfly$(IDXfly%) = "- - "
            End If
            
      End Select
      
    If Not IsNull(CRSobj_tmp(3)) Then STSfly$(IDXfly%) = CRSobj_tmp(3)
    
    CRSobj_tmp.MoveNext
  Loop
  
CRSobj_tmp.Close

FLYcmp_max& = 0

  For IDXi% = 1 To 3
    CLMx% = CLMx% + 1
    RECx$ = RECx$ + HGHfly$(IDXi%) + Chr(CLMx%)
    
    CLMx% = CLMx% + 1
    RECx$ = RECx$ + ERRfly$(IDXi%) + Chr(CLMx%)
    
    CLMx% = CLMx% + 1
    RECx$ = RECx$ + STSfly$(IDXi%) + Chr(CLMx%)
              
      If POScnt_cmp& = 1 Then
        If Val(HGHfly$(IDXi%)) > HGHmax& Then HGHmax& = Val(HGHfly$(IDXi%)): IDXmax& = IDXi%
      End If
    
  Next IDXi%
  
  If POScnt_cmp& = 1 Then
    IDXcmp_win = NBRx$: NAMcmp_win = CRSobj_mnt(1) + " - " + CRSobj_mnt(2)
    IDXfly_win = LTrim(Str(IDXmax&))
  End If
  

CLMx% = CLMx% + 1
If ALTcnt_cmp& > 0 Then RECx$ = RECx$ + LTrim(Str(ALTcnt_cmp&))
RECx$ = RECx$ + Chr(CLMx%)

CLMx% = CLMx% + 1
If ALTcnt_cmp& > 0 Then RECx$ = RECx$ + LTrim(Str(POScnt_cmp&))
RECx$ = RECx$ + Chr(CLMx%)

MntCtrFmtRecord$ = RECx$

'========================================================================================================
                                                                                             End Function


'********************************************************************************************************
'*********************************** ANZEIGE DER LISTE DER WETTKMPFER **********************************
'
  Sub MntCtrShwRecList()
'
'........................................................................................................



X1% = 150: X2% = MNT_CTR.RecLstPct.Width - 120
DY% = TOPspc_lst - HGHrow_lst

MNT_CTR.RecLstPct.BackColor = 0
MNT_CTR.RecLstPct.Refresh
T# = Timer
Do: Loop Until Timer - T# > 0.5

  For ROWi% = 1 To NBRrow_mnt
    RECx% = ROWi% + NRCscr_mnt
      If RECx% > NRCdat_mnt Then Exit For

    YY& = DY% + ROWi% * HGHrow_lst
    GoSub ShwRecord
    MNT_CTR.RecLstPct.Refresh

  Next ROWi%
    

                                                                                                 Exit Sub
'********************************************************************************************************
ShwRecord:

MNT_CTR.RecLstPct.CurrentY = YY&

MNT_CTR.RecLstPct.ForeColor = &HFFFF00
MNT_CTR.RecLstPct.FontBold = 1
CLMi% = 1: P2% = InStr(RECdat_mnt(RECx%), Chr(CLMi%)) '................................... StartNummer >|
VALx$ = Mid(RECdat_mnt(RECx%), 1, P2% - 1)
MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(CLMi%) - MNT_CTR.RecLstPct.TextWidth(VALx$)
MNT_CTR.RecLstPct.Print VALx$;
    
MNT_CTR.RecLstPct.FontBold = 0
CLMi% = CLMi% + 1: P1% = P2% + 1: P2% = InStr(P1%, RECdat_mnt(RECx%), Chr(CLMi%)) '.............. Name |<
VALx$ = "   " + Mid(RECdat_mnt(RECx%), P1%, P2% - P1%)
MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(1)
MNT_CTR.RecLstPct.Print VALx$;

CLMi% = CLMi% + 1: P1% = P2% + 1: P2% = InStr(P1%, RECdat_mnt(RECx%), Chr(CLMi%)) '..... Lic/Club/Land >|
VALx$ = Mid(RECdat_mnt(RECx%), P1%, P2% - P1%)
MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(2) - MNT_CTR.RecLstPct.TextWidth(VALx$)
MNT_CTR.RecLstPct.Print VALx$;

MNT_CTR.RecLstPct.ForeColor = &HFFFFFF

  For I% = 1 To 3
    CLMi% = CLMi% + 1: P1% = P2% + 1: P2% = InStr(P1%, RECdat_mnt(RECx%), Chr(CLMi%)) '............. H >|
    HGHx$ = Mid(RECdat_mnt(RECx%), P1%, P2% - P1%)
    If Val(HGHx$) > 0 Then HGHx$ = HGHx$ + " m"
    MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(CLMi%) - MNT_CTR.RecLstPct.TextWidth(HGHx$)
    MNT_CTR.RecLstPct.Print HGHx$;
    
    CLMi% = CLMi% + 1: P1% = P2% + 1: P2% = InStr(P1%, RECdat_mnt(RECx%), Chr(CLMi%)) '............ DH >|
    VALx$ = Mid(RECdat_mnt(RECx%), P1%, P2% - P1%)
    If Val(HGHx$) > 0 Then VALx$ = VALx$ + "%"
    MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(CLMi%) - MNT_CTR.RecLstPct.TextWidth(VALx$)
    MNT_CTR.RecLstPct.Print VALx$;
    
    CLMi% = CLMi% + 1: P1% = P2% + 1: P2% = InStr(P1%, RECdat_mnt(RECx%), Chr(CLMi%)) '............ OK |<
    VALx$ = Mid(RECdat_mnt(RECx%), P1%, P2% - P1%)
    MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(CLMi%)
    MNT_CTR.RecLstPct.Print VALx$;
  Next I%

MNT_CTR.RecLstPct.ForeColor = &HFFFF&
MNT_CTR.RecLstPct.FontBold = 1

CLMi% = CLMi% + 1: P1% = P2% + 1: P2% = InStr(P1%, RECdat_mnt(RECx%), Chr(CLMi%)) '................... HH
VALx$ = Mid(RECdat_mnt(RECx%), P1%, P2% - P1%)
If Val(VALx$) > 0 Then VALx$ = VALx$ + " m"
MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(CLMi%) - MNT_CTR.RecLstPct.TextWidth(VALx$)
MNT_CTR.RecLstPct.Print VALx$;

CLMi% = CLMi% + 1: P1% = P2% + 1: P2% = InStr(P1%, RECdat_mnt(RECx%), Chr(CLMi%)) '................... PP
VALx$ = Mid(RECdat_mnt(RECx%), P1%, P2% - P1%)
If Val(VALx$) > 0 Then VALx$ = VALx$ + "."
MNT_CTR.RecLstPct.CurrentX = TABmnt_lst(CLMi%) - MNT_CTR.RecLstPct.TextWidth(VALx$)
MNT_CTR.RecLstPct.Print VALx$;

                                                                                                   Return
'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'******************************* LADEN DER ERGEBNIS-LISTE EINES WETTBEWRBS ******************************
'
  Sub MntCtrLodContest()
'
'........................................................................................................

  
  '.................................................................................... Datenbank-Connect
  If DBScnn_mnt = 0 Then
    MntCtrDbsConnect
    If DBScnn_mnt = 0 Then Exit Sub
  End If
  

'.................................................................... Index des anzuzeigenden Wettbewerbs
FLNmnt$ = DIRhom_mnt + "\S1X.MNT"

  If Dir(FLNmnt$) = "" Then
    TXTmsg_stp = "No information about monitoring - will try a Demo of last stored contest"
    MNT_STP.Show 1
    
            QRYx$ = " SELECT max(cnt_index)"
    QRYx$ = QRYx$ + " FROM s1x_cnt"
    
    On Error GoTo LodCntDbsErr
    Set CRSobj_mnt = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)
    On Error GoTo 0
    
      If CRSobj_mnt(0) = 0 Then CRSobj_mnt.Close: TXTmsg_stp = "- No Contests stored -": Exit Sub
  
    IDXcnt_new% = CRSobj_mnt(0)
  
  Else
    Open FLNmnt$ For Input As #99
    INI$ = Input$(LOF(99), #99)
    Close #99
    
    IDXcnt_new% = Val(INI$)
      If IDXcnt_new% = 0 Then TXTmsg_stp = "- Current Index in S1X.MNT not found -": Exit Sub
  
  End If


'................................................................................. Titel des Wettbewerbs
IDXx$ = Str(IDXcnt_new%)

        QRYx$ = " SELECT"
QRYx$ = QRYx$ + " titel, category"
QRYx$ = QRYx$ + " FROM s1x_cnt WHERE cnt_index =" + IDXx$

On Error GoTo LodCntDbsErr
Set CRSobj_mnt = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)
On Error GoTo 0

  If CRSobj_mnt.EOF Then CRSobj_mnt.Close: TXTmsg_stp = "- Contest" + IDXx$ + " not found -": Exit Sub
  
If Not IsNull(CRSobj_mnt(0)) Then TXTcnt$ = CRSobj_mnt(0)
If Not IsNull(CRSobj_mnt(1)) Then TXTcnt$ = TXTcnt$ + " - " + CRSobj_mnt(1)
  

'.......................................................................................... MeStationen
        
        QRYx$ = " SELECT "
QRYx$ = QRYx$ + " stc_index,"
QRYx$ = QRYx$ + " hrz_rct, hrz_prc,"
QRYx$ = QRYx$ + " vtc_rct, vtc_prc,"
QRYx$ = QRYx$ + " lft_stc, rgt_stc,"
QRYx$ = QRYx$ + " vtc_lnc, dst_lnc"
QRYx$ = QRYx$ + " FROM s1x_stc WHERE cnt_index =" + IDXx$

Set CRSobj_mnt = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)

CRSobj_mnt.MoveLast
NBRmsr_stc = CRSobj_mnt.RecordCount
CRSobj_mnt.MoveFirst

  For STCi% = 1 To NBRmsr_stc
    STCi% = CRSobj_mnt(0)
    RCTstc_hrz(STCi%) = CRSobj_mnt(1)
    PRCstc_hrz(STCi%) = CRSobj_mnt(2)
    RCTstc_vtc(STCi%) = CRSobj_mnt(3)
    PRCstc_vtc(STCi%) = CRSobj_mnt(4)
    ALPstc_lnc(STCi%) = CRSobj_mnt(5)
    BTAstc_lnc(STCi%) = CRSobj_mnt(6)
    GMAstc_lnc(STCi%) = CRSobj_mnt(7)
    DSTstc_lnc(STCi%) = CRSobj_mnt(8)
    CRSobj_mnt.MoveNext
  Next STCi%

MntCtrClcLocation
        
'......................................................................... Wettkmpfer und EndErgebnisse
        
        QRYx$ = " SELECT "
QRYx$ = QRYx$ + " cmp_index, name, name_add, result, place"
QRYx$ = QRYx$ + " FROM s1x_cmp WHERE cnt_index =" + Str(IDXcnt_new%)
QRYx$ = QRYx$ + " ORDER BY cmp_index"

On Error GoTo LodCntDbsErr
Set CRSobj_mnt = DBSobj_mnt.OpenRecordset(QRYx$, 2, 4)
On Error GoTo 0

  If CRSobj_mnt.EOF Then CRSobj_mnt.Close: TXTmsg_stp = "- No Comptitors stored for requested contest -": Exit Sub
    
CRSobj_mnt.MoveLast
NBRrec& = CRSobj_mnt.RecordCount
CRSobj_mnt.MoveFirst

ReDim RECdat_tmp$(NBRrec&)
WDTcmp_max = 0: CMPwdt_max = ""

On Error GoTo LodCntDbsErr
  
  For CMPi% = 1 To NBRrec&
    RECdat_tmp$(CMPi%) = MntCtrFmtRecord$(IDXcnt_new%)
    CRSobj_mnt.MoveNext
  Next CMPi%

CRSobj_mnt.Close
On Error GoTo 0


IDXcnt_mnt = IDXcnt_new%
CPTcnt_mnt = TXTcnt$
NRCdat_mnt = NBRrec&

ReDim RECdat_mnt(NRCdat_mnt)

  For CMPi% = 1 To NRCdat_mnt
    RECdat_mnt(CMPi%) = RECdat_tmp$(CMPi%)
  Next CMPi%

MntCtrSetMonitor

                                                                                                 Exit Sub
'********************************************************************************************************
LodCntDbsErr:

On Error Resume Next
DBSobj_mnt.Close
On Error GoTo 0

DBScnn_mnt = 0

TXTmsg_stp = "- Can not read ContestData - Access denied -"
Resume LodCntEnd


LodCntMntErr:
TXTmsg_stp = "- File S1X.MNT not found -"
Resume LodCntEnd

LodCntIdxErr:
TXTmsg_stp = "- Current Index in S1X.MNT not found -"
Resume LodCntEnd

LodCntEnd:

'********************************************************************************************************
                                                                                                  End Sub

























'********************************************************************************************************
'***************************** BERECHNUNG DES FLUGFELDES EINES WETTBEWERBS ******************************
'
   Sub MntCtrClcLocation()
'
'  NBRmsr_stc- Anzahl der Mestellen des Wettbewerbs
'  RCTstc_hrz() - Werte rechter HorizontalWinkel
'  RCTstc_vtc() - Werte rechter VertikalWinkel
'  ALPstc_lnc() - Gemessene Winkel der Mestellen zur vorherigen Mestelle
'  ALPstl_bgm() - Werte ALPstc_lnc() umgerechnet in Bogenma
'  BTAstc_lnc() - Gemessene Winkel der Mestellen zur nchsten Mestelle
'  BTAstl_bgm() - Werte BTAstc_lnc() umgerechnet in Bogenma
'  GMAstc_lnc() - Gemessene VertikalWinkel der Mestellen zur StartStelle
'  GMAstc_bgm() - Werte GMAstc_lnc() umgerechnet in Bogenma
'  DSTstc_lnc() - Gemessene Abstnde der Mestellen zur StartStelle
'
'          Z                DSTstc_lnc(1)
'        <-------     M1--------------------- L
'                      \ BTAstc_lnc(1)      .   .
'                       \             OMG .       .
'                        \              .           .
'                         \           .   DSTstc_lnc_pxz       usw.
'            DSTstc_stc(1) \  ALPstc_lnc(2)             ./
'                           \     .                     / .
'                            \  .  BTAstc_lnc(2)       /    .
'                             M2-------------------- M3       .
'                                  DSTstc_stc(2)                . X
'
'
'  OMGstl_bgm() - Winkel zwischen AbstandsLinie zur StartStelle und Z-Achse
'  DSTstc_lnc_pxz() - Projektion von DSTstc_lnc() auf die Ebene der StartStelle
'
'  ERRomg_grd   - WinkelDifferenz zum VollKreis
'
'........................................................................................................


'............................................................................ LISTE DER MESSSTELLEN-PAARE

'............................................................................. Anzahl der MestellenPaare
NBRstc_duo = 0

  For STCi% = 1 To NBRmsr_stc - 1
    NBRstc_duo = NBRstc_duo + STCi%
  Next STCi%


'........................................................................ UMRECHNUNG DER POSITIONS-WINKEL

  For STCi% = 1 To NBRmsr_stc
    If RCTstc_hrz(STCi%) <> 0 Then ALPstl_bgm(STCi%) = Pi090 * ALPstc_lnc(STCi%) / RCTstc_hrz(STCi%)
    If RCTstc_hrz(STCi%) <> 0 Then BTAstl_bgm(STCi%) = Pi090 * BTAstc_lnc(STCi%) / RCTstc_hrz(STCi%)
    If RCTstc_vtc(STCi%) <> 0 Then GMAstl_bgm(STCi%) = Pi090 * GMAstc_lnc(STCi%) / RCTstc_vtc(STCi%)
  Next STCi%


'............................................. RAUMKOORDINATEN UND WINKEL DER ABSTANDS-LINIEN ZUR Z-ACHSE
'
'                                              DSTstc_lnc_pxz
'                              -------------------------------------------0
'                                    .       GMA                          |
'                                            .                            |
'                                                    .                    | YYY
'                                                           .             |
'                                                                   .     |
'                                                                         |
'
'........................................................................................................
'
'                                                         ZZZn            |
'                              -------------------------------------------|--------
'                                                           :           ..|
'                                                           : OMGn-1 .  . |
'                                                           :     .    .  |
'                                                           :  .      .   |
'                                                           :        .    |
'                                                        .  :       .     |
'                                                 Mn-1.     :      . OMGn |
'                                                    \BTAn-1:     .       |
'                                                     \     :    .        |
'                                                      \    :   . DSTn    |
'                                                       \   :  .          |
'                                                        \ALPn.           |
'                                                         \ :.            |
'                                                          \..............| XXXn
'                                                          . Mn           |
'                                                        N.
'........................................................................................................


'............................................................................................ Mestelle 1
DSTstc_lnc_pxz(1) = DSTstc_lnc(1) * Cos(-GMAstl_bgm(1))
ZZZstc_loc(1) = DSTstc_lnc_pxz(1)
OMGstl_bgm(1) = 0

  '.................................................................................... brige Mestellen
  For STCi% = 2 To NBRmsr_stc
    DSTstc_lnc_pxz(STCi%) = DSTstc_lnc(STCi%) * Cos(-GMAstl_bgm(STCi%))
    OMGstl_bgm(STCi%) = OMGstl_bgm(STCi% - 1) + Pi180 - ALPstl_bgm(STCi%) + BTAstl_bgm(STCi% - 1)
    
    XXXstc_loc(STCi%) = DSTstc_lnc_pxz(STCi%) * Sin(OMGstl_bgm(STCi%))
    ZZZstc_loc(STCi%) = DSTstc_lnc_pxz(STCi%) * Cos(OMGstl_bgm(STCi%))
    YYYstc_loc(STCi%) = DSTstc_lnc_pxz(STCi%) * Sin(-GMAstl_bgm(STCi%))
  Next STCi%

'............................................................................... DIFFERENZ ZUM VOLL-KREIS
'
'                                                        Mn ..............| XXXn
'                                                         . :.            |
'                                                       .   : .           |
'   ERRomg = 360 - (OMGn + (180 - ALP1 - (-BTAn)))    .     :  .          |
'                                                   .       :   .         |
'                                                 .    BTAn :    .        |
'                                               .           :     .  OMGn |
'                                             .             :      .      |
'                                           .               :       .     |
'                                         .                 :        .    |
'                                       .                   :         .   |
'                                     .                     :          .  |
'                                   .   ALP1                :           . |
'                                 .                         :            .|
'                              -------------------------------------------|--------
'                                M1                        ZZZn           |
'........................................................................................................

     

'.......................................................... ABSTNDE ZWISCHEN BENACHBARTEN MESS-STATIONEN

'......................................................................................... Linke Nachbarn

'............................................................................................ Mestelle 1
DX# = XXXstc_loc(1) - XXXstc_loc(NBRmsr_stc)
DZ# = ZZZstc_loc(1) - ZZZstc_loc(NBRmsr_stc)
DY# = YYYstc_loc(1) - YYYstc_loc(NBRmsr_stc)
DSTstc_stc(1, 1) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)
If DSTstc_stc(1, 1) < 10 Then LSTdst_err = " 1&" + LTrim(Str(NBRmsr_stc)) + ","

  '.................................................................................... brige Mestellen
  For STCi% = 2 To NBRmsr_stc
    DX# = XXXstc_loc(STCi%) - XXXstc_loc(STCi% - 1)
    DZ# = ZZZstc_loc(STCi%) - ZZZstc_loc(STCi% - 1)
    DY# = YYYstc_loc(STCi%) - YYYstc_loc(STCi% - 1)
    DSTstc_stc(STCi%, 1) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)
  Next STCi%

'........................................................................................ Rechte Nachbarn
  
  For STCi% = 1 To NBRmsr_stc - 1
    DX# = XXXstc_loc(STCi%) - XXXstc_loc(STCi% + 1)
    DZ# = ZZZstc_loc(STCi%) - ZZZstc_loc(STCi% + 1)
    DY# = YYYstc_loc(STCi%) - YYYstc_loc(STCi% + 1)
    DSTstc_stc(STCi%, 2) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)
  Next STCi%
  
'....................................................................................... Letzte Mestelle
DX# = XXXstc_loc(NBRmsr_stc) - XXXstc_loc(1)
DZ# = ZZZstc_loc(NBRmsr_stc) - ZZZstc_loc(1)
DY# = YYYstc_loc(NBRmsr_stc) - YYYstc_loc(1)
DSTstc_stc(NBRmsr_stc, 2) = Sqr(DX# ^ 2 + DZ# ^ 2 + DY# ^ 2)

'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'************************************ FFNEN DER S1X-DATENBANK ******************************************
'
  Sub MntCtrDbsConnect()
'
'........................................................................................................


'.............................................................................. Verzeichnis der Datenbank
If Right(PTHdbs_mnt, 1) = "\" Then PTHdbs_mnt = Left(PTHdbs_mnt, Len(PTHdbs_mnt) - 1)
  
  If PTHdbs_mnt = "" Then
    TXTmsg_stp = "Path for S1X-DataBase in S1X.INI not set."
    MNT_STP.Show 1
    Exit Sub
  End If
  
On Error GoTo DbsDirErr
  ChDrive Left(PTHdbs_mnt, 1): ChDir PTHdbs_mnt
On Error GoTo 0
      

'........................................................................................... ODBC-Connect
DBSx$ = PTHdbs_mnt: CNNx$ = "dbase iv"

On Error GoTo OpnDbsErr
Set DBSobj_mnt = OpenDatabase(DBSx$, 0, 0, CNNx$)
On Error GoTo 0

'........................................................................................ Datenbank-Files
FLNtbl$ = "S1X_CNT.DBF"

  If Dir(PTHdbs_mnt + "\" + FLNtbl$) = "" Then
    TXTmsg_stp = "S1X-DataBase in [" + PTHdbs_mnt + "] is corrupt."
    TXTmsg_stp = TXTmsg_stp + "  DataBase-Table " + FLNtbl$ + " not found."
    GoTo DbsOpnEnd
  End If

FLNtbl$ = "S1X_CMP.DBF"

  If Dir(PTHdbs_mnt + "\" + FLNtbl$) = "" Then
    TXTmsg_stp = "S1X-DataBase in [" + PTHdbs_mnt + "] is corrupt."
    TXTmsg_stp = TXTmsg_stp + "  DataBase-Table " + FLNtbl$ + " not found."
    GoTo DbsOpnEnd
  End If

FLNtbl$ = "S1X_FLY.DBF"

  If Dir(PTHdbs_mnt + "\" + FLNtbl$) = "" Then
    TXTmsg_stp = "S1X-DataBase in [" + PTHdbs_mnt + "] is corrupt."
    TXTmsg_stp = TXTmsg_stp + "  DataBase-Table " + FLNtbl$ + " not found."
    GoTo DbsOpnEnd
  End If
  
DBScnn_mnt = 1
  
                                                                                                 Exit Sub
'********************************************************************************************************

'--------------------------------------------------------------------------------------------------------
DbsDirErr:

TXTmsg_stp = "Path for S1X-DataBase [" + PTHdbs_mnt + "] not found."
Resume DbsOpnEnd

'--------------------------------------------------------------------------------------------------------
OpnDbsErr:

TXTmsg_stp = Error
Resume DbsOpnEnd

'--------------------------------------------------------------------------------------------------------
DbsOpnEnd:

If TXTmsg_stp > "" Then MNT_STP.Show 1

'********************************************************************************************************
                                                                                                  End Sub








'========================================================================================================
'======================= FORMATIEREN VON WERTEN AUS DER DATENBANK FR DIE ANZEIGE =======================
'
  Function MntCtrFmtNumber$(VALx$, FMTx$)
'
'........................................................................................................


VALfmt$ = Trim(VALx$)

  Select Case Left(FMTx$, 3)

    Case "NBR" '.................................................................................. ZAHLEN
     
        Select Case Mid(FMTx$, 6, 1)
          Case "_" '............................................................................ GanzZahl
            LENmax% = Val(Mid(FMTx$, 5, 1))
            If Mid(FMTx$, 7, 1) = "0" Then VALfmt$ = String(LENmax% - Len(VALfmt$), "0") + VALfmt$
          
          Case "," '......................................................................... DezimalZahl
            Pq% = InStr(VALfmt$, ".")
            If Pq% = 0 Then VALfmt$ = VALfmt$ + ".": Pq% = Len(VALfmt$)
            If Pq% = 1 Then VALfmt$ = "0" + VALfmt$: Pq% = 2
              
            LENdec% = Val(Mid(FMTx$, 7, 1))
            VALfmt$ = Left(VALfmt$, Pq% + LENdec%)
            VALfmt$ = VALfmt$ + String(LENdec% - Len(VALfmt$) + Pq%, "0")
              
            If LCDlng_mnt = "GER" Then Mid(VALfmt$, Pq%, 1) = ","
        
        End Select


  End Select


MntCtrFmtNumber$ = VALfmt$

'========================================================================================================
                                                                                             End Function







'========================================================================================================
'========================================================================================================
'
  Function MntCtrGetTxtSection(INI$, SCTx$)
'
'........................................................................................................

    
MntCtrGetTxtSection = ""

Pq% = InStr(UCase(INI$), "[" + UCase(SCTx$) + "]")
  If Pq% = 0 Then Exit Function
      
P1% = InStr(Pq%, INI$, Chr$(10)) + 1
  If P1% = 1 Then Exit Function

P2% = InStr(P1%, INI$, Chr$(10) + "[") + 1
  If P2% = 1 Then P2% = Len(INI$) + 1

MntCtrGetTxtSection = Chr$(10) + Mid(INI$, P1%, P2% - P1%)

'========================================================================================================
                                                                                             End Function









'========================================================================================================
'========================================================================================================
'
   Function MntCtrGetTxtOption(SCTtxt$, OPTx$)
'
'........................................................................................................

IniMntCtrGetTxtOption = ""

Pq% = InStr(UCase(SCTtxt$), Chr(10) + OPTx$)
  If Pq% = 0 Then Exit Function
      
P1% = InStr(Pq%, SCTtxt$, "=") + 1
  If P1% = 1 Then Exit Function
              
P2% = InStr(P1%, SCTtxt$, Chr$(13))
  If P2% = 0 Then P2% = Len(SCTtxt$) + 1

OptTxt$ = Trim(Mid$(SCTtxt$, P1%, P2% - P1%))

Pq% = InStr(OptTxt$, "'.")
  If Pq% > 0 Then OptTxt$ = Left(OptTxt$, Pq% - 1)

MntCtrGetTxtOption = OptTxt$

'========================================================================================================
                                                                                             End Function




'********************************************************************************************************
'********************************************************************************************************
'
  Sub MntCtrIni()
'
'........................................................................................................


FLNx$ = "S1X?????.EXE"

  On Error Resume Next
    If Dir(FLNx$) = "" Then ChDrive Left(App.Path, 1): ChDir App.Path
    If Dir(FLNx$) = "" Then ChDrive "C": ChDir "C:\PROJECTS\S1X"
    If Dir(FLNx$) = "" Then ChDrive "D": ChDir "D:\BASIC\PROJECTS\S1X"
  On Error GoTo 0
    
    
    If Dir(FLNx$) = "" Then
      TXTmsg_stp = "- So Sorry! - S1X-HomeDirectory not found -"
      MNT_STP.Show 1: End
    End If
    
DIRhom_mnt = CurDir

FLNini$ = DIRhom_mnt + "\S1X.INI"
  
    If Dir$(FLNini$) = "" Then
      TXTmsg_stp = "- So Sorry! - File S1X.INI not found -"
      MNT_STP.Show 1: End
    End If

Open FLNini$ For Input As #99
INI$ = Input$(LOF(99), #99)
Close #99
    
SCTtxt$ = MntCtrGetTxtSection(INI$, "S1X")
    
    If SCTtxt$ = "" Then
      TXTmsg_stp = "- So Sorry! - File S1X.INI is invalid -"
      MNT_STP.Show 1: End
    End If

PTHdbs_mnt = MntCtrGetTxtOption(SCTtxt$, "DBS_S1X")
LCDlng_mnt = MntCtrGetTxtOption(SCTtxt$, "LNG_S1X")
  If LCDlng_mnt = "" Then LCDlng_mnt = "GER"


Pi090 = 2 * Atn(1)
Pi180 = 3.14159265358979
Pi360 = 6.28318530717958



'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'********************************************************************************************************
'
  Sub MntCtrShwCntTitel()
'
'........................................................................................................


MNT_CTR.Cls

CHRx$ = CPTcnt_mnt
DL% = 30 * Len(CPTcnt_mnt) - 30

MNT_CTR.Cls
FNTsiz% = Int(1.5 * MNT_CTR.RecLstPct.FontSize)

  Do
    MNT_CTR.FontSize = FNTsiz%
      If MNT_CTR.TextWidth(CPTcnt_mnt) + DL% < Screen.Width - MNT_CTR.HdrImg.Width - 600 Then Exit Do
      
    FNTsiz% = FNTsiz% - 1
  Loop


XX& = 0.33 * (Screen.Width - MNT_CTR.HdrImg.Width - MNT_CTR.TextWidth(CPTcnt_mnt) - DL%)
YY& = 0.33 * (MNT_CTR.HdrImg.Height - MNT_CTR.TextHeight(""))

 
 For PP% = 1 To Len(CPTcnt_mnt)
    CHRx$ = Mid(CPTcnt_mnt, PP%, 1)
    
    MNT_CTR.ForeColor = &HC0&
    MNT_CTR.CurrentX = XX&: MNT_CTR.CurrentY = YY& + 0: MNT_CTR.Print CHRx$;
    MNT_CTR.CurrentX = XX&: MNT_CTR.CurrentY = YY& + 30: MNT_CTR.Print CHRx$;
    MNT_CTR.CurrentX = XX& + 15: MNT_CTR.CurrentY = YY& + 15: MNT_CTR.Print CHRx$;
    MNT_CTR.CurrentX = XX& - 15: MNT_CTR.CurrentY = YY& + 15: MNT_CTR.Print CHRx$;
    
    MNT_CTR.ForeColor = &HFF&
    MNT_CTR.CurrentX = XX&: MNT_CTR.CurrentY = YY& + 15: MNT_CTR.Print CHRx$;
    
    XX& = XX& + MNT_CTR.TextWidth(CHRx$) + 30
    MNT_CTR.Refresh
 Next PP%


'********************************************************************************************************
                                                                                                  End Sub












'********************************************************************************************************
'********************************************************************************************************
'
  Sub MntCtrSetMonitor()
'
'........................................................................................................



'............................................................................................. FondsGre
RECx$ = "999   " + CMPwdt_max + "      9999 m  999%  WW   9999 m  999%  WW   9999 m  999%  WW"
RECx$ = RECx$ + "     9999 m 99."
  
FNTsiz_new% = 48

  Do
    MNT_CTR.FontSize = FNTsiz_new%
      If MNT_CTR.TextWidth(RECx$) < Screen.Width Then Exit Do
      
    FNTsiz_new% = FNTsiz_new% - 1
  Loop

HGHrow_lst = Int(1.3 * MNT_CTR.TextHeight(""))

'...................................................................................... SpaltenPositionen
TABold_4% = TABmnt_lst(4)

TABx% = 1: '....................................................................... StartNummer >|<__Name
TABmnt_lst(TABx%) = MNT_CTR.TextWidth("999   ")

TABx% = TABx% + 1 '.............................................................................. Club >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth(CMPwdt_max)

TABx% = TABx% + 1 '................................................................................... <>
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("   ")

TABx% = TABx% + 1 '............................................................................... H1m >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("   9999 m")

TABx% = TABx% + 1 '.............................................................................. DH1% >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("  999%")

TABx% = TABx% + 1 '............................................................................... OK1 |<
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("  ")

TABx% = TABx% + 1 '............................................................................... H2m >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("WW   9999 m")

TABx% = TABx% + 1 '.............................................................................. DH2% >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("  999%")

TABx% = TABx% + 1 '............................................................................... OK2 |<
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("  ")

TABx% = TABx% + 1 '............................................................................... H3m >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("WW   9999 m")

TABx% = TABx% + 1 '.............................................................................. DH3% >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("  999%")

TABx% = TABx% + 1 '............................................................................... OK3 |<
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("  ")

TABx% = TABx% + 1 '............................................................................... HHm >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth("WW     9999 m")
         
TABx% = TABx% + 1 '................................................................................ PP >|
TABmnt_lst(TABx%) = TABmnt_lst(TABx% - 1) + MNT_CTR.TextWidth(" 99.")
      

  '.................................................................................... SpaltenBezeichner
  If TABmnt_lst(4) <> TABold_4% Then
    MNT_CTR.ClmNamPct.FontSize = Int(1.3 * FNTsiz_new%)
    MNT_CTR.ClmNamPct.FontBold = 0
    MNT_CTR.ClmNamPct.Cls
    
    LFTx% = 0.5 * (Screen.Width - TABmnt_lst(14))
    MNT_CTR.ClmNamPct.Move LFTx%, MNT_CTR.HdrImg.Height + HGHrow_lst, TABmnt_lst(14), MNT_CTR.ClmNamPct.TextHeight("")
    DX& = MNT_CTR.ClmNamPct.TextWidth("99")
    
    MNT_CTR.ClmNamPct.ForeColor = &HFFFF00
    If LCDlng_mnt = "GER" Then CPTx$ = "Wettkmpfer" Else CPTx$ = "Competitor"
    XX& = TABmnt_lst(1) - MNT_CTR.RecLstPct.TextWidth("99"): GoSub LodFrmSetCpt
    
    MNT_CTR.ClmNamPct.ForeColor = &HFFFFFF
    If LCDlng_mnt = "GER" Then CPTx$ = "Flug 1" Else CPTx$ = "Flight 1"
    XX& = TABmnt_lst(4) - DX&
    GoSub LodFrmSetCpt
    
    If LCDlng_mnt = "GER" Then CPTx$ = "Flug 2" Else CPTx$ = "Flight 2"
    XX& = TABmnt_lst(7) - DX&
    GoSub LodFrmSetCpt
    
    If LCDlng_mnt = "GER" Then CPTx$ = "Flug 3" Else CPTx$ = "Flight 3"
    XX& = TABmnt_lst(10) - DX&
    GoSub LodFrmSetCpt
            
    MNT_CTR.ClmNamPct.ForeColor = &HFFFF&
    MNT_CTR.ClmNamPct.FontBold = 1
    If LCDlng_mnt = "GER" Then CPTx$ = "Resultat" Else CPTx$ = "Result"
    XX& = TABmnt_lst(14) - MNT_CTR.ClmNamPct.TextWidth(CPTx$)
    GoSub LodFrmSetCpt
  End If
  
'.................................................................................................. Liste
TOPlst% = MNT_CTR.ClmNamPct.Top + MNT_CTR.ClmNamPct.Height + HGHrow_lst
NBRrow_mnt = Int((Screen.Height - TOPlst%) / HGHrow_lst)

LFTx% = 0.5 * (Screen.Width - TABmnt_lst(14))
HGHlst% = NBRrow_mnt * HGHrow_lst + TOPspc_lst + 60
MNT_CTR.RecLstPct.Move LFTx%, TOPlst%, Screen.Width, HGHlst%
MNT_CTR.RecLstPct.FontSize = FNTsiz_new%

MNT_CTR.MntTmr.Interval = 500 * NBRrow_mnt


                                                                                                 Exit Sub
'********************************************************************************************************
LodFrmSetCpt:

MNT_CTR.ClmNamPct.CurrentX = XX&: MNT_CTR.ClmNamPct.CurrentY = 0: MNT_CTR.ClmNamPct.Print CPTx$;

                                                                                                   Return
'********************************************************************************************************
                                                                                                  End Sub


