// IGCshellDlg.cpp : implementation file
//
// Copyright (c) 2000-2001 Marc Ramsey. All rights reserved.
//
// http://www.ranlog.com/ramsey/
//
// This software is provided as is with no warranties of any kind, 
// including the warranties of design, merchantibility and fitness 
// for a particular purpose, noninfringement, or arising from a 
// course of dealing, usage or trade practice.  This software is 
// provided with no support and without any obligation to assist in 
// its use, correction, modification, or enhancement.
//
// Permission to use, copy, or modify this software for any purpose 
// is hereby granted without fee, provided the above notices are 
// retained on all copies of the source code. 

#include "stdafx.h"
#include "IGCshell.h"
#include "IGCshellDlg.h"
#include "DownloadDlg.h"
#include "SettingsDlg.h"
#include "IGCAPI.H"
#include "enumser.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CIGCshellApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	afx_msg void OnRanlogUrl();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_BN_CLICKED(IDC_RANLOG_URL, OnRanlogUrl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIGCshellDlg dialog

CIGCshellDlg::CIGCshellDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CIGCshellDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIGCshellDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CIGCshellDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIGCshellDlg)
	DDX_Control(pDX, ID_EXIT, m_exit);
	DDX_Control(pDX, IDC_FLIGHT_RECORDER, m_flight_recorder);
	DDX_Control(pDX, IDC_VALIDATE, m_validate);
	DDX_Control(pDX, IDC_SERIAL_OPTIONS, m_serial_options);
	DDX_Control(pDX, IDC_DOWNLOAD, m_download);
	DDX_Control(pDX, IDC_CONVERT, m_convert);
	DDX_Control(pDX, IDC_COMM_PORT, m_comm_port);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIGCshellDlg, CDialog)
	//{{AFX_MSG_MAP(CIGCshellDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CONVERT, OnConvert)
	ON_BN_CLICKED(IDC_DOWNLOAD, OnDownload)
	ON_BN_CLICKED(IDC_SERIAL_OPTIONS, OnSerialOptions)
	ON_BN_CLICKED(IDC_VALIDATE, OnValidate)
	ON_CBN_SELCHANGE(IDC_COMM_PORT, OnChangeCommPort)
	ON_BN_CLICKED(IDC_SETTINGS, OnSettings)
	ON_CBN_SELCHANGE(IDC_FLIGHT_RECORDER, OnChangeFlightRecorder)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(ID_EXIT, OnOK)
END_MESSAGE_MAP()

void CIGCshellDlg::LoadIGCDLLs()
{
	// Load all DLLs
	LPCTSTR dlldir = theApp.mDLLDirectory.IsEmpty() ?
							NULL : (LPCTSTR)theApp.mDLLDirectory;
	int dllcount = LoadAllDLLs(dlldir);
	if (dllcount == 0) {
		// No dlls, warn user
		AfxMessageBox(IDS_NO_DLLS, MB_OK|MB_ICONWARNING);
	}

	// Initialize flight recorder list
	CString selectfr;
	HICON icon = theApp.LoadIcon(IDR_MAINFRAME);
	COMBOBOXEXITEM item;
	int selectIndex = 0;

	m_flight_recorder.ResetContent();
	m_iconList.DeleteImageList();
	m_iconList.Create(32, 32, ILC_COLOR4, 4, 4);
	m_flight_recorder.SetImageList(&m_iconList);
	selectfr.LoadString(IDS_SELECTFR);
	ZeroMemory(&item, sizeof(item));
	item.mask = CBEIF_TEXT|CBEIF_IMAGE|CBEIF_SELECTEDIMAGE;
	item.pszText = (LPTSTR)(LPCTSTR)selectfr;
	item.iSelectedImage = item.iImage = m_iconList.Add(icon);
	m_flight_recorder.InsertItem(&item);

	for (int i = 0; i < dllcount; i++) {
		TCHAR code[8], man[128], model[128], rev[128], text[256];

		SelectDLL(i);
		IdentifyDLLField(IDDLL_CODE, code, sizeof(code));
		IdentifyDLLField(IDDLL_MANUFACTURER, man, sizeof(man));
		IdentifyDLLField(IDDLL_MODEL, model, sizeof(model));
		IdentifyDLLField(IDDLL_REVISION, rev, sizeof(rev));
		_stprintf(text, "%s %s, %s", man, rev, model);
		item.mask = CBEIF_TEXT;
		item.iItem = i + 1;
		item.pszText = text;
		if (icon = LoadIconDLL()) {
			item.iSelectedImage = item.iImage = m_iconList.Add(icon);
			item.iOverlay = 1;
			if (item.iImage != -1)
				item.mask |= CBEIF_IMAGE|CBEIF_SELECTEDIMAGE;
		}
		m_flight_recorder.InsertItem(&item);
		if (theApp.mFlightRecorder == code)
			selectIndex = i + 1;
	}

	m_flight_recorder.SetCurSel(selectIndex);
	OnChangeFlightRecorder();
}

/////////////////////////////////////////////////////////////////////////////
// CIGCshellDlg message handlers

BOOL CIGCshellDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Load all IGC DLLs

	LoadIGCDLLs();

	// Initalize comm port list

	CUIntArray ports;
	if (!(EnumerateSerialPorts2(ports)
		  || EnumerateSerialPorts1(ports)
		  || EnumerateSerialPorts3(ports))
		 || ports.GetSize() == 0) {
		// No serial ports
		AfxMessageBox(IDS_NO_COMM_PORTS, MB_OK|MB_ICONWARNING);
		// Disable downloads and serial options,
		// can still validate or convert
		m_download.EnableWindow(FALSE);
		m_serial_options.EnableWindow(FALSE);
	}
	m_comm_port.ResetContent();

	for (int s = 0; s < ports.GetSize(); s++) {
		TCHAR item[32];
		_stprintf(item, "COM%d", ports.ElementAt(s));
		m_comm_port.AddString(item);
	}

	if (!theApp.mCommPort.IsEmpty())
		m_comm_port.SelectString(-1, theApp.mCommPort);
	else {
		m_comm_port.SetCurSel(0);
		OnChangeCommPort();
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIGCshellDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CIGCshellDlg::OnDestroy()
{
	UnloadAllDLLs();
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CIGCshellDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CIGCshellDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CIGCshellDlg::OnConvert() 
{
	TCHAR extensions[128];
	CString dlgTitle;
	dlgTitle.LoadString(IDS_CONVERT_DLG_TITLE);
	IdentifyDLLExt(IDDLL_CONVERT_EXT, extensions, sizeof(extensions));

	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY, extensions, this);
	dlg.m_ofn.lpstrTitle = (LPCTSTR)dlgTitle;
	if (dlg.DoModal() == IDOK) {
		CString logname = dlg.GetPathName();
		CString igcname = logname;
		int dot = logname.ReverseFind('.');
		if (dot > 0)
			igcname.Delete(dot, igcname.GetLength() - dot);
		igcname += _T(".IGC");
		ConvertLog(logname, igcname);
	}
}

void CIGCshellDlg::OnDownload() 
{
	CDownloadDlg dlg(this);

	SetWindowDLL(dlg.m_hWnd);
	dlg.DoModal();
	SetWindowDLL(m_hWnd);
}

void CIGCshellDlg::OnChangeFlightRecorder() 
{
	int index = m_flight_recorder.GetCurSel() - 1;

	if (index >= 0) {
		TCHAR code[8];

		SelectDLL(index);
		IdentifyDLLField(IDDLL_CODE, code, sizeof(code));
		theApp.mFlightRecorder = code;
		InitializeDLL(m_hWnd, FALSE);
		m_serial_options.EnableWindow(UseSerialOptionsDLL());
		m_download.EnableWindow(TRUE);
		m_convert.EnableWindow(UseConvertLog());
		m_validate.EnableWindow(TRUE);
		m_download.SetFocus();
	} else {
		theApp.mFlightRecorder.Empty();
		m_serial_options.EnableWindow(FALSE);
		m_download.EnableWindow(FALSE);
		m_convert.EnableWindow(FALSE);
		m_validate.EnableWindow(FALSE);
		m_exit.SetFocus();
	}
}

void CIGCshellDlg::OnSerialOptions() 
{
	TCHAR options[64];
	CString regOptions;

	regOptions = theApp.GetProfileString(theApp.mFlightRecorder, _T("SerialOptions"));
	_tcsncpy(options, (LPCTSTR)regOptions, sizeof(options));
	if (SerialOptionsDLL(options, sizeof(options)) > 0)
		theApp.WriteProfileString(theApp.mFlightRecorder, _T("SerialOptions"), options);
}

void CIGCshellDlg::OnValidate() 
{
	TCHAR extensions[128];
	CString dlgTitle;
	dlgTitle.LoadString(IDS_VALIDATE_DLG_TITLE);
	IdentifyDLLExt(IDDLL_VALIDATE_EXT, extensions, sizeof(extensions));

	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY, extensions, this);
	dlg.m_ofn.lpstrTitle = (LPCTSTR)dlgTitle;
	if (dlg.DoModal() == IDOK && ValidateLog(dlg.GetPathName()))
		AfxMessageBox(IDS_VALIDATE_OK, MB_OK|MB_ICONINFORMATION);
}

void CIGCshellDlg::OnChangeCommPort() 
{
	m_comm_port.GetLBText(m_comm_port.GetCurSel(), theApp.mCommPort);
}

void CIGCshellDlg::OnSettings() 
{
	CSettingsDialog dlg(this);
	CString DLLDir = theApp.mDLLDirectory;
	dlg.DoModal();
	if (DLLDir != theApp.mDLLDirectory) {
		UnloadAllDLLs();
		LoadIGCDLLs();
	}
}

void CAboutDlg::OnRanlogUrl() 
{
	ShellExecute(theApp.m_pMainWnd->m_hWnd, "Open",
        "http://www.ranlog.com/ramsey/", "", "", 1);
}

BOOL CIGCshellDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	BOOL result = TRUE;

	if (pHelpInfo->iContextType == HELPINFO_WINDOW)
		AfxGetApp()->WinHelp(pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	else
		result = CDialog::OnHelpInfo(pHelpInfo);

	return result;
}
